$(document).ready(async function () {
  componenteFiltro('funcionario', false, false, 'SolicitanteCapa')
  componenteFiltro('tabPrazo', false, false, 'PrazoCapa')
  componenteFiltro('colecao', false, false, 'ColecaoCapa')
  componenteFiltro('motivo', false, false, 'MotivoCapa')
  componenteFiltro('tipoOp', false, false, 'TipoCapa')
  componenteFiltro('tabPreco', false, false, 'TabelaPrecoCapa')
  componenteFiltro('centroCusto', false, false, 'CentroCustoCapa')

  componenteFiltro('material', false, false, 'CodigoMaterial')
  componenteFiltro('cor', false, false, 'CorMaterial')
  componenteFiltro('deposito', false, false, 'DepositoMaterial')
  componenteFiltro('contaContabil', false, false, 'ContaContabilMaterial')
  componenteFiltro('ordemCompra', false, false, 'OcMaterial')

  componenteFiltro('produto', false, false, 'CodigoProduto')
  componenteFiltro('cor', false, false, 'CorProduto')
  componenteFiltro('tamanho', false, false, 'TamanhoProduto')
  componenteFiltro('deposito', false, false, 'DepositoProduto')
  componenteFiltro('contaContabil', false, false, 'ContaContabilProduto')

  componenteFiltro('servico', false, false, 'CodigoServico')
  componenteFiltro('contaContabil', false, false, 'ContaContabilServico')

  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#tabItens').on('click', () => setTimeout(
    () => $('#tabelaMateriaisManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabProdutos').on('click', () => setTimeout(
    () => $('#tabelaProdutosManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabServicos').on('click', () => setTimeout(
    () => $('#tabelaServicosManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#btnAlterarCapa').on('click', () => habilitarAlteracaoCapa())

  $('#btnDesistirCapa').on('click', () => {
    resetForm('#formCapa')
    ModalManutencaoCentralCompras.preencherCamposCapa(ModalManutencaoCentralCompras.dadosCapa)
    desabilitarAlteracaoCapa()
  })

  const habilitarAlteracaoCapa = () => {
    $('.controleCapaManutencao').prop('disabled', false)
    $('#btnAlterarCapa').addClass('d-none')
    $('#btnConfirmarCapa').removeClass('d-none')
    $('#btnDesistirCapa').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoCapa = () => {
    $('.controleCapaManutencao').prop('disabled', true)
    $('#btnAlterarCapa').removeClass('d-none')
    $('#btnConfirmarCapa').addClass('d-none')
    $('#btnDesistirCapa').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
  }

  $('#formCapa').validate({
    rules: {
      solicitante: {
        required: true,
      },
      tipo: {
        required: true,
      }
    },
    messages: {
      solicitante: 'Solicitante é obrigatório.',
      tipo: 'Tipo é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      ModalManutencaoCentralCompras.dadosCapa = retornarDadosCapa()
      desabilitarAlteracaoCapa()
    }
  })

  const retornarDadosCapa = () => {
    const numero = $('#txtNumeroCapa').val()
    const usuario = $('#txtUsuarioCapa').val()
    const dataCadastro = $('#txtCadastroCapa').val()
    const dataEmissao = $('#txtEmissaoCapa').val()
    const dataEntrega = $('#txtEntregaCapa').val()
    const dataBaixa = $('#txtBaixaCapa').val()
    const solicitante = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtSolicitanteCapa')
    const prazo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtPrazoCapa')
    const colecao = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtColecaoCapa')
    const motivo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtMotivoCapa')
    const tipo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtTipoCapa')
    const tabelaPreco = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtTabelaPrecoCapa')
    const centroCusto = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCentroCustoCapa')
    const observacao = $('#txtObservacaoCapa').val()

    return {
      numero,
      usuario,
      dataCadastro,
      dataEmissao,
      dataEntrega,
      dataBaixa,
      solicitante: solicitante?.chave,
      descricaoSolicitante: solicitante?.descricao,
      prazo: prazo?.chave,
      descricaoPrazo: prazo?.descricao,
      colecao: colecao?.chave,
      descricaoColecao: colecao?.descricao,
      motivo: motivo?.chave,
      descricaoMotivo: motivo?.descricao,
      tipo: tipo?.chave,
      descricaoTipo: tipo?.descricao,
      tabelaPreco: tabelaPreco?.chave,
      descricaoTabelaPreco: tabelaPreco?.descricao,
      centroCusto: centroCusto?.chave,
      descricaoCentroCusto: centroCusto?.descricao,
      observacao,
    }
  }

  $('#btnAlterarMaterial').on('click', () => habilitarAlteracaoMaterial())

  $('#btnDesistirMaterial').on('click', () => {
    resetForm('#formMaterial')
    desabilitarAlteracaoMaterial()
  })

  $('#btnExcluirMaterial').on('click', () => excluirMaterial())

  $('#btnIncluirMaterial').on('click', () => {
    $('#tabelaMateriaisManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoCentralCompras.limparCamposMaterial()
    habilitarAlteracaoMaterial()
  })

  $('#txtQuantidadeMaterial, #txtPrecoMaterial').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeMaterial').val(),
    preco: $('#txtPrecoMaterial').val(),
    inputValor: '#txtValorMaterial'
  }))

  const habilitarAlteracaoMaterial = () => {
    $('.controleMaterialManutencao').prop('disabled', false)
    $('#btnAlterarMaterial').addClass('d-none')
    $('#btnExcluirMaterial').addClass('d-none')
    $('#btnIncluirMaterial').addClass('d-none')
    $('#btnConfirmarMaterial').removeClass('d-none')
    $('#btnDesistirMaterial').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoMaterial = () => {
    $('.controleMaterialManutencao').prop('disabled', true)
    $('#btnAlterarMaterial').removeClass('d-none')
    $('#btnExcluirMaterial').removeClass('d-none')
    $('#btnIncluirMaterial').removeClass('d-none')
    $('#btnConfirmarMaterial').addClass('d-none')
    $('#btnDesistirMaterial').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaMateriaisManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoCentralCompras.limparCamposMaterial()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaMateriaisManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoCentralCompras.preencherCamposMaterial(data)
  }

  const excluirMaterial = () => {
    const datatableMateriais = $('#tabelaMateriaisManutencao').DataTable()
    const [indice] = datatableMateriais?.rows({ selected: true }).indexes().toArray()
    datatableMateriais.row(indice).remove().draw(false)
    if (datatableMateriais.rows().count() > 0)
      datatableMateriais.row(':first').select()
    else
      ModalManutencaoCentralCompras.limparCamposMaterial()
  }

  const confirmarMaterial = () => {
    const data = retornarDadosConfirmarMaterial()
    const datatableMateriais = $('#tabelaMateriaisManutencao').DataTable()
    const [indice] = datatableMateriais?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarMaterial({
        datatable: datatableMateriais,
        data,
        indice,
      })
    else
      incluirMaterial({
        datatable: datatableMateriais,
        data,
      })
    desabilitarAlteracaoMaterial()
  }

  const alterarMaterial = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirMaterial = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarMaterial = () => {
    const material = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCodigoMaterial')
    const cor = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCorMaterial')
    const deposito = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtDepositoMaterial')
    const ordemCompra = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtOcMaterial')
    const contaContabil = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtContaContabilMaterial')
    const especificacao = $('#txtEspecificacaoMaterial').val()
    const unidade = $('#txtUnidadeMaterial').val()
    const unidadeCompra = $('#txtUnidadeCompraMaterial').val()
    const fatorConversao = $('#txtFatorConversaoMaterial').val()
    const quantidade = $('#txtQuantidadeMaterial').val()
    const preco = $('#txtPrecoMaterial').val()
    const valor = $('#txtValorMaterial').val()

    return {
      codigo: material?.chave,
      descricao: material?.descricao,
      cor: cor?.chave,
      descricaoCor: cor?.descricao,
      tamanho: '',
      descricaoTamanho: '',
      deposito: deposito?.chave,
      descricaoDeposito: deposito?.descricao,
      ordemCompra: ordemCompra?.chave,
      fornecedorOrdemCompra: ordemCompra?.descricao,
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade,
      unidadeCompra,
      fatorConversao,
      quantidade,
      preco,
      valor,
      tipoItem: 'M',
    }
  }

  $('#formMaterial').validate({
    rules: {
      codigo: {
        required: true,
      },
      cor: {
        required: true,
      },
      deposito: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Material é obrigatório.',
      cor: 'Cor é obrigatória.',
      deposito: 'Depósito é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarMaterial()
    }
  })

  $('#btnAlterarProduto').on('click', () => habilitarAlteracaoProduto())

  $('#btnDesistirProduto').on('click', () => {
    resetForm('#formProduto')
    desabilitarAlteracaoProduto()
  })

  $('#btnExcluirProduto').on('click', () => excluirProduto())

  $('#btnIncluirProduto').on('click', () => {
    $('#tabelaProdutosManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoCentralCompras.limparCamposProduto()
    habilitarAlteracaoProduto()
  })

  $('#txtQuantidadeProduto, #txtPrecoProduto').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeProduto').val(),
    preco: $('#txtPrecoProduto').val(),
    inputValor: '#txtValorProduto'
  }))

  const habilitarAlteracaoProduto = () => {
    $('.controleProdutoManutencao').prop('disabled', false)
    $('#btnAlterarProduto').addClass('d-none')
    $('#btnExcluirProduto').addClass('d-none')
    $('#btnIncluirProduto').addClass('d-none')
    $('#btnConfirmarProduto').removeClass('d-none')
    $('#btnDesistirProduto').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoProduto = () => {
    $('.controleProdutoManutencao').prop('disabled', true)
    $('#btnAlterarProduto').removeClass('d-none')
    $('#btnExcluirProduto').removeClass('d-none')
    $('#btnIncluirProduto').removeClass('d-none')
    $('#btnConfirmarProduto').addClass('d-none')
    $('#btnDesistirProduto').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaProdutosManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoCentralCompras.limparCamposProduto()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaProdutosManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoCentralCompras.preencherCamposProduto(data)
  }

  const excluirProduto = () => {
    const datatableProduto = $('#tabelaProdutoManutencao').DataTable()
    const [indice] = datatableProduto?.rows({ selected: true }).indexes().toArray()
    datatableProduto.row(indice).remove().draw(false)
    if (datatableProduto.rows().count() > 0)
      datatableProduto.row(':first').select()
    else
      ModalManutencaoCentralCompras.limparCamposProduto()
  }

  const confirmarProduto = () => {
    const data = retornarDadosConfirmarProduto()
    const datatableProdutos = $('#tabelaProdutosManutencao').DataTable()
    const [indice] = datatableProdutos?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarProduto({
        datatable: datatableProdutos,
        data,
        indice,
      })
    else
      incluirProduto({
        datatable: datatableProdutos,
        data,
      })
    desabilitarAlteracaoProduto()
  }

  const alterarProduto = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirProduto = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarProduto = () => {
    const produto = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCodigoProduto')
    const cor = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCorProduto')
    const tamanho = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtTamanhoProduto')
    const deposito = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtDepositoProduto')
    const contaContabil = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtContaContabilProduto')
    const especificacao = $('#txtEspecificacaoProduto').val()
    const unidade = $('#txtUnidadeProduto').val()
    const unidadeCompra = $('#txtUnidadeCompraProduto').val()
    const quantidade = $('#txtQuantidadeProduto').val()
    const preco = $('#txtPrecoProduto').val()
    const valor = $('#txtValorProduto').val()

    return {
      codigo: produto?.chave,
      descricao: produto?.descricao,
      cor: cor?.chave,
      descricaoCor: cor?.descricao,
      tamanho: tamanho?.chave,
      descricaoTamanho: tamanho?.descricao,
      deposito: deposito?.chave,
      descricaoDeposito: deposito?.descricao,
      ordemCompra: '',
      fornecedorOrdemCompra: '',
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade,
      unidadeCompra,
      fatorConversao: '',
      quantidade,
      preco,
      valor,
      tipoItem: 'P',
    }
  }

  $('#formProduto').validate({
    rules: {
      codigo: {
        required: true,
      },
      cor: {
        required: true,
      },
      tamanho: {
        required: true,
      },
      deposito: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Produto é obrigatório.',
      cor: 'Cor é obrigatória.',
      tamanho: 'Tamanho é obrigatório.',
      deposito: 'Depósito é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarProduto()
    }
  })

  $('#btnAlterarServico').on('click', () => habilitarAlteracaoServico())

  $('#btnDesistirServico').on('click', () => {
    resetForm('#formServico')
    desabilitarAlteracaoServico()
  })

  $('#btnExcluirServico').on('click', () => excluirServico())

  $('#btnIncluirServico').on('click', () => {
    $('#tabelaServicosManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoCentralCompras.limparCamposServico()
    habilitarAlteracaoServico()
  })

  $('#txtQuantidadeServico, #txtPrecoServico').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeServico').val(),
    preco: $('#txtPrecoServico').val(),
    inputValor: '#txtValorServico'
  }))

  const habilitarAlteracaoServico = () => {
    $('.controleServicoManutencao').prop('disabled', false)
    $('#btnAlterarServico').addClass('d-none')
    $('#btnExcluirServico').addClass('d-none')
    $('#btnIncluirServico').addClass('d-none')
    $('#btnConfirmarServico').removeClass('d-none')
    $('#btnDesistirServico').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoServico = () => {
    $('.controleServicoManutencao').prop('disabled', true)
    $('#btnAlterarServico').removeClass('d-none')
    $('#btnExcluirServico').removeClass('d-none')
    $('#btnIncluirServico').removeClass('d-none')
    $('#btnConfirmarServico').addClass('d-none')
    $('#btnDesistirServico').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaServicosManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoCentralCompras.limparCamposServico()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaServicosManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoCentralCompras.preencherCamposServico(data)
  }

  const excluirServico = () => {
    const datatableServico = $('#tabelaServicosManutencao').DataTable()
    const [indice] = datatableServico?.rows({ selected: true }).indexes().toArray()
    datatableServico.row(indice).remove().draw(false)
    if (datatableServico.rows().count() > 0)
      datatableServico.row(':first').select()
    else
      ModalManutencaoCentralCompras.limparCamposServico()
  }

  const confirmarServico = () => {
    const data = retornarDadosConfirmarServico()
    const datatableServicos = $('#tabelaServicosManutencao').DataTable()
    const [indice] = datatableServicos?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarServico({
        datatable: datatableServicos,
        data,
        indice,
      })
    else
      incluirServico({
        datatable: datatableServicos,
        data,
      })
    desabilitarAlteracaoServico()
  }

  const alterarServico = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirServico = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarServico = () => {
    const servico = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCodigoServico')
    const contaContabil = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtContaContabilServico')
    const especificacao = $('#txtEspecificacaoServico').val()
    const quantidade = $('#txtQuantidadeServico').val()
    const preco = $('#txtPrecoServico').val()
    const valor = $('#txtValorServico').val()

    return {
      codigo: servico?.chave,
      descricao: servico?.descricao,
      cor: '',
      descricaoCor: '',
      tamanho: '',
      descricaoTamanho: '',
      deposito: '',
      descricaoDeposito: '',
      ordemCompra: '',
      fornecedorOrdemCompra: '',
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade: '',
      unidadeCompra: '',
      fatorConversao: '',
      quantidade,
      preco,
      valor,
      tipoItem: 'S',
    }
  }

  $('#formServico').validate({
    rules: {
      codigo: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Serviço é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarServico()
    }
  })

  const calcularValorItem = ({ quantidade, preco, inputValor }) => {
    if (!quantidade) {
      $('#txtValorMaterial').val('0.00')
      return
    }
    if (!preco) {
      $('#txtValorMaterial').val('0.00')
      return
    }

    const valor = (parseFloat(quantidade) * parseFloat(preco)).toFixed(2)
    $(inputValor).val(valor)
  }

  $('#btnConfirmar').on('click', () => {
    msgAlerta(
      'Deseja gravar os dados?',
      () => null,
      () => null,
      () => {
        const dados = retornarDadosConfirmar()
        if (!validarDadosConfirmar(dados)) return
        confirmar(dados)
      }
    )
  })

  const validarDadosConfirmar = ({ capa, status, itens }) => {
    if (!status) {
      return
    }

    if (!capa) {
      msgErro('Capa inválida, impossível continuar.')
      return
    }

    if (!itens || !itens.length || itens.length === 0) {
      msgErro('Nenhum item informado, impossível continuar.')
      return false
    }

    return true
  }

  const confirmar = (dados) => {
    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/centralcompras/v1/gravarmanutencaoeretornardadosatualizados?`,
      '',
      JSON.stringify(dados),
      3600000
    ).then(async (response) => {
      const json = await response.json()
      if (json) {
        const { mensagem, resultado } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) return
        const { itens } = resultado

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            if (!itens) return
            const { App } = ModalManutencaoCentralCompras
            App.atualizarItens(itens[0]?.numero, itens)
            $('#modalManutencao').modal('hide')
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const retornarDadosConfirmar = () => {
    // const dados = $(form).serializeArray()
    // console.log(dados)

    // const capa = {}
    // dados.forEach(({ name, value }) => capa[name] = ModalManutencaoCentralCompras.retornarChaveDescricao(value))
    // console.log(capa)
    // return
    const numero = $('#txtNumeroCapa').val()
    const usuario = $('#txtUsuarioCapa').val()
    const dataCadastro = $('#txtCadastroCapa').val()
    const dataEmissao = $('#txtEmissaoCapa').val()
    const dataEntrega = $('#txtEntregaCapa').val()
    const dataBaixa = $('#txtBaixaCapa').val()
    const solicitante = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtSolicitanteCapa')
    const prazo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtPrazoCapa')
    const colecao = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtColecaoCapa')
    const motivo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtMotivoCapa')
    const tipo = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtTipoCapa')
    const tabelaPreco = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtTabelaPrecoCapa')
    const centroCusto = ModalManutencaoCentralCompras.retornarChaveDescricao('#txtCentroCustoCapa')
    const observacao = $('#txtObservacaoCapa').val()

    const capa = {
      numero,
      usuario,
      dataCadastro,
      dataEmissao,
      dataEntrega,
      dataBaixa,
      solicitante: solicitante.chave,
      descricaoSolicitante: solicitante.descricao,
      prazo: prazo.chave,
      descricaoPrazo: prazo.descricao,
      colecao: colecao.chave,
      descricaoColecao: colecao.descricao,
      motivo: motivo.chave,
      descricaoMotivo: motivo.descricao,
      tipo: tipo.chave,
      descricaoTipo: tipo.descricao,
      tabelaPreco: tabelaPreco.chave,
      descricaoTabelaPreco: tabelaPreco.descricao,
      centroCusto: centroCusto.chave,
      descricaoCentroCusto: centroCusto.descricao,
      observacao,
    }

    const status = $('#selectStatus').val()

    const itens = [
      ...$('#tabelaMateriaisManutencao').DataTable().data().toArray(),
      ...$('#tabelaProdutosManutencao').DataTable().data().toArray(),
      ...$('#tabelaServicosManutencao').DataTable().data().toArray(),
    ]

    return {
      capa,
      status,
      itens,
    }
  }

  const resetForm = (formSelector) => {
    $(formSelector)[0].reset()
    const validator = $(formSelector).validate()
    validator.resetForm()
    $(formSelector)
      .find('.error')
      .removeClass('error')
  }

  $('#modalManutencao').on('shown.bs.modal', () => ModalManutencaoCentralCompras.carregarApp($('#selectStatus').val()))

  $('#modalManutencao').on('hide.bs.modal', () => {
    ModalManutencaoCentralCompras.limparModal()
    $('#tabMateriais').tab('show')
    $('#tabCapa').tab('show')
  })
})

window.ModalManutencaoCentralCompras = window.ModalManutencaoCentralCompras || {}

ModalManutencaoCentralCompras.App = null

ModalManutencaoCentralCompras.carregarApp = (status) => {
  switch (status) {
    case 'D':
      ModalManutencaoCentralCompras.App = ItensDigitadosCentralCompras
      break
    case 'B':
      ModalManutencaoCentralCompras.App = ItensBloqueadosCentralCompras
      break
    case 'R':
      ModalManutencaoCentralCompras.App = ItensRetornadosCentralCompras
      break
    case 'L':
      ModalManutencaoCentralCompras.App = ItensLiberadosCentralCompras
      break
    case 'C':
      ModalManutencaoCentralCompras.App = ItensCotadosCentralCompras
      break
    default:
      break
  }
}

ModalManutencaoCentralCompras.dadosCapa = {}

ModalManutencaoCentralCompras.retornarChaveDescricao = (id) => {
  const textoInput = $(id).val()
  // if (valor.indexOf('[') < 0) {
  //   return valor
  // }
  const chave = textoInput.substring(1, textoInput.indexOf("]"))
  const descricao = textoInput.substring(textoInput.indexOf("]") + 4, textoInput.length)

  return {
    chave,
    descricao,
  }
}

ModalManutencaoCentralCompras.limparModal = () => {
  ModalManutencaoCentralCompras.limparCamposCapa()
  ModalManutencaoCentralCompras.limparCamposMaterial()
  if ($.fn.DataTable.isDataTable('#tabelaMateriaisManutencao')) {
    $('#tabelaMateriaisManutencao').DataTable().destroy()
    $('#tabelaMateriaisManutencao').empty()
  }
}

ModalManutencaoCentralCompras.carregarModalManutencao = (dadosEditar, situacao) => {
  ModalManutencaoCentralCompras.preencherDadosModalEditar(dadosEditar)
  $('#selectStatus').val(situacao)
  $('#modalManutencao').modal('show')
}

ModalManutencaoCentralCompras.preencherDadosModalEditar = (dados) => {
  const [dadosCapa] = dados
  const materiais = []
  const produtos = []
  const servicos = []
  ModalManutencaoCentralCompras.preencherCamposCapa(dadosCapa)
  ModalManutencaoCentralCompras.dadosCapa = dadosCapa
  dados.forEach((item) => {
    switch (item.tipoItem) {
      case 'M':
        materiais.push(item)
        break
      case 'P':
        produtos.push(item)
        break
      case 'S':
        servicos.push(item)
        break
      default:
        break
    }
  })
  ModalManutencaoCentralCompras.criarTabelaMateriaisManutencao(materiais)
  ModalManutencaoCentralCompras.criarTabelaProdutosManutencao(produtos)
  ModalManutencaoCentralCompras.criarTabelaServicosManutencao(servicos)
}



ModalManutencaoCentralCompras.preencherCamposCapa = (dados) => {
  if (!dados) return
  dados.numero ? insereValor('#txtNumeroCapa', dados.numero) : $('#txtNumeroCapa').val('')
  dados.usuario ? insereValor('#txtUsuarioCapa', dados.usuario) : $('#txtUsuarioCapa').val('')
  dados.dataCadastro ? insereValor('#txtCadastroCapa', dados.dataCadastro.split('T')[0]) : $('#txtCadastroCapa').val('')
  dados.dataEmissao ? insereValor('#txtEmissaoCapa', dados.dataEmissao.split('T')[0]) : $('#txtEmissaoCapa').val('')
  dados.dataEntrega ? insereValor('#txtEntregaCapa', dados.dataEntrega.split('T')[0]) : $('#txtEntregaCapa').val('')
  dados.dataBaixa ? insereValor('#txtBaixaCapa', dados.dataBaixa.split('T')[0]) : $('#txtBaixaCapa').val('')
  dados.solicitante ? insereValor('#txtSolicitanteCapa', dados.solicitante, dados.descricaoSolicitante) : $('#txtSolicitanteCapa').val('')
  dados.prazo ? insereValor('#txtPrazoCapa', dados.prazo, dados.descricaoPrazo) : $('#txtPrazoCapa').val('')
  dados.colecao ? insereValor('#txtColecaoCapa', dados.colecao, dados.descricaoColecao) : $('#txtColecaoCapa').val('')
  dados.motivo ? insereValor('#txtMotivoCapa', dados.motivo, dados.descricaoMotivo) : $('#txtMotivoCapa').val('')
  dados.tipo ? insereValor('#txtTipoCapa', dados.tipo, dados.descricaoTipo) : $('#txtTipoCapa').val('')
  dados.tabelaPreco ? insereValor('#txtTabelaPrecoCapa', dados.tabelaPreco, dados.descricaoTabelaPreco) : $('#txtTabelaPrecoCapa').val('')
  dados.centroCusto ? insereValor('#txtCentroCustoCapa', dados.centroCusto, dados.descricaoCentroCusto) : $('#txtCentroCustoCapa').val('')
  dados.observacao ? insereValor('#txtObservacaoCapa', dados.observacao) : $('#txtObservacaoCapa').val('')
}

ModalManutencaoCentralCompras.limparCamposCapa = () => $('.camposCapaManutencao').val('')



ModalManutencaoCentralCompras.limparCamposMaterial = () => $('.camposMaterialManutencao').val('')

ModalManutencaoCentralCompras.preencherCamposMaterial = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoMaterial', dados.codigo, dados.descricao) : $('#txtCodigoMaterial').val('')
  dados.cor ? insereValor('#txtCorMaterial', dados.cor, dados.descricaoCor) : $('#txtCorMaterial').val('')
  dados.deposito ? insereValor('#txtDepositoMaterial', dados.deposito, dados.descricaoDeposito) : $('#txtDepositoMaterial').val('')
  dados.ordemCompra ? insereValor('#txtOcMaterial', dados.ordemCompra, dados.fornecedorOrdemCompra) : $('#txtOcMaterial').val('')
  dados.contaContabil ? insereValor('#txtContaContabilMaterial', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilMaterial').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoMaterial', dados.especificacao) : $('#txtEspecificacaoMaterial').val('')
  dados.unidade ? insereValor('#txtUnidadeMaterial', dados.unidade) : $('#txtUnidadeMaterial').val('')
  dados.unidadeCompra ? insereValor('#txtUnidadeCompraMaterial', dados.unidadeCompra) : $('#txtUnidadeMaterial').val('')
  dados.fatorConversao ? insereValor('#txtFatorConversaoMaterial', parseFloat(dados.fatorConversao).toFixed(2)) : $('#txtFatorConversaoMaterial').val('0.00')
  dados.quantidade ? insereValor('#txtQuantidadeMaterial', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeMaterial').val('0.00')
  dados.preco ? insereValor('#txtPrecoMaterial', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoMaterial').val('0.00')
  insereValor('#txtValorMaterial', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoCentralCompras.criarTabelaMateriaisManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaMateriaisManutencao')) {
    $('#tabelaMateriaisManutencao').DataTable().destroy()
    $('#tabelaMateriaisManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
      visible: false,
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaMateriaisManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoCentralCompras.preencherCamposMaterial(data)
    }
  })
  $('#tabelaMateriaisManutencao').DataTable().row(':first').select()
}



ModalManutencaoCentralCompras.limparCamposProduto = () => $('.camposProdutoManutencao').val('')

ModalManutencaoCentralCompras.preencherCamposProduto = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoProduto', dados.codigo, dados.descricao) : $('#txtCodigoProduto').val('')
  dados.cor ? insereValor('#txtCorProduto', dados.cor, dados.descricaoCor) : $('#txtCorProduto').val('')
  dados.tamanho ? insereValor('#txtTamanhoProduto', dados.tamanho, dados.descricaoTamanho) : $('#txtTamanhoProduto').val('')
  dados.deposito ? insereValor('#txtDepositoProduto', dados.deposito, dados.descricaoDeposito) : $('#txtDepositoProduto').val('')
  dados.ordemCompra ? insereValor('#txtOcProduto', dados.ordemCompra, dados.fornecedorOrdemCompra) : $('#txtOcProduto').val('')
  dados.contaContabil ? insereValor('#txtContaContabilProduto', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilProduto').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoProduto', dados.especificacao) : $('#txtEspecificacaoProduto').val('')
  dados.unidade ? insereValor('#txtUnidadeProduto', dados.unidade) : $('#txtUnidadeProduto').val('')
  dados.unidadeCompra ? insereValor('#txtUnidadeCompraProduto', dados.unidadeCompra) : $('#txtUnidadeProduto').val('')
  dados.quantidade ? insereValor('#txtQuantidadeProduto', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeProduto').val('0.00')
  dados.preco ? insereValor('#txtPrecoProduto', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoProduto').val('0.00')
  insereValor('#txtValorProduto', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoCentralCompras.criarTabelaProdutosManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaProdutosManutencao')) {
    $('#tabelaProdutosManutencao').DataTable().destroy()
    $('#tabelaProdutosManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      visible: false,
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaProdutosManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoCentralCompras.preencherCamposProduto(data)
    }
  })
  $('#tabelaProdutosManutencao').DataTable().row(':first').select()
}



ModalManutencaoCentralCompras.limparCamposServico = () => $('.camposServicoManutencao').val('')

ModalManutencaoCentralCompras.preencherCamposServico = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoServico', dados.codigo, dados.descricao) : $('#txtCodigoServico').val('')
  dados.contaContabil ? insereValor('#txtContaContabilServico', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilServico').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoServico', dados.especificacao) : $('#txtEspecificacaoServico').val('')
  dados.quantidade ? insereValor('#txtQuantidadeServico', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeServico').val('0.00')
  dados.preco ? insereValor('#txtPrecoServico', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoServico').val('0.00')
  insereValor('#txtValorServico', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoCentralCompras.criarTabelaServicosManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaServicosManutencao')) {
    $('#tabelaServicosManutencao').DataTable().destroy()
    $('#tabelaServicosManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
      visible: false,
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
      visible: false,
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
      visible: false,
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
      visible: false,
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
      visible: false,
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
      visible: false,
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
      visible: false,
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
      visible: false,
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      visible: false,
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaServicosManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoCentralCompras.preencherCamposServico(data)
    }
  })
  $('#tabelaServicosManutencao').DataTable().row(':first').select()
}